import QtQuick 2.15
import QtQuick.Controls 2.15
import styles 1.0

ToolButton {
    id: control
    property alias iconSource: control.icon.source
    property bool useThemeTint: true
    property color lightIconColor: Theme.textPrimary
    property color darkIconColor: Theme.textPrimary

    focusPolicy: Qt.TabFocus
    implicitWidth: 36
    implicitHeight: 36
    display: AbstractButton.IconOnly

    icon.width: 24
    icon.height: 24
    icon.color: control.useThemeTint ? (Theme.isDark ? control.darkIconColor : control.lightIconColor) : Qt.rgba(1, 1, 1, 1)
}
