import QtQuick 2.15
import QtQuick.Controls 2.15
import styles 1.0

Button {
    id: control
    implicitHeight: 36
    font.pixelSize: 14
    font.bold: true
    padding: Theme.spacingSm
    focusPolicy: Qt.TabFocus

    contentItem: Label {
        text: control.text
        font: control.font
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        elide: Text.ElideRight
        color: control.enabled ? Theme.textOnAccent
                                : Theme._withAlpha(Theme.textOnAccent, 0.6)
    }

    background: Rectangle {
        id: bg
        radius: Theme.panelRadius
        border.color: Theme._withAlpha(Theme._black, 0.16)
        color: control.enabled
               ? (control.down
                    ? Theme._mix(Theme.accent, Theme._black, 0.15)
                    : (control.hovered
                        ? Theme._mix(Theme.accent, Theme._white, 0.06)
                        : Theme.accent))
               : Theme._withAlpha(Theme.accent, 0.5)
    }
}
