import QtQuick 2.15
import QtQuick.Controls 2.15
import styles 1.0

Button {
    id: control
    checkable: true
    autoExclusive: true
    implicitHeight: 36
    font.pixelSize: 14

    background: Rectangle {
        radius: Theme.panelRadius - 4
        color: control.checked
            ? Theme.accent
            : (control.hovered && control.enabled
                ? Qt.rgba(Theme.textPrimary.r, Theme.textPrimary.g, Theme.textPrimary.b, 0.08)
                : Qt.rgba(Theme.textPrimary.r, Theme.textPrimary.g, Theme.textPrimary.b, 0.04))
        border.width: control.checked ? 0 : 1
        border.color: Theme.surfaceBorder
    }

    contentItem: Label {
        text: control.text
        color: control.checked ? Theme.textOnAccent : Theme.textPrimary
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }
}
