import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Controls.impl 2.15 as ControlsImpl

import styles 1.0

Control {
    id: root
    objectName: "themeToggleSwitch"
    implicitWidth: 96
    implicitHeight: 36
    padding: 4
    focusPolicy: Qt.NoFocus

    readonly property bool dark: Theme.mode === "dark"
    readonly property url sunSource: Theme.iconUrl("sun")
    readonly property url moonSource: Theme.iconUrl("moon")

    background: Rectangle {
        implicitWidth: root.implicitWidth
        implicitHeight: root.implicitHeight
        radius: height / 2
        color: Theme.toggleTrack
        border.color: Theme.toggleTrackBorder
        border.width: 1
    }

    contentItem: Item {
        id: track
        anchors.fill: parent
        anchors.margins: root.padding

        readonly property real sunCenter: width * 0.25
        readonly property real moonCenter: width * 0.75

        Rectangle {
            id: knob
            z: 0
            width: 36
            height: 28
            radius: height / 2
            color: root.dark ? Theme.toggleKnobActive : Theme.toggleKnobInactive
            border.width: 1
            border.color: root.dark ? Theme.toggleKnobActiveBorder : Theme.toggleKnobInactiveBorder
            anchors.verticalCenter: parent.verticalCenter
            x: (root.dark ? track.moonCenter : track.sunCenter) - width / 2

            Behavior on x {
                NumberAnimation { duration: 160; easing.type: Easing.InOutQuad }
            }

            Behavior on color {
                ColorAnimation { duration: 120; easing.type: Easing.InOutQuad }
            }

            Behavior on border.color {
                ColorAnimation { duration: 120; easing.type: Easing.InOutQuad }
            }

            ControlsImpl.IconImage {
                anchors.centerIn: parent
                source: root.dark ? root.moonSource : root.sunSource
                width: 18
                height: 18
                color: root.dark ? Theme.textOnAccent : Theme.textPrimary
            }
        }

        ControlsImpl.IconImage {
            id: sunIcon
            z: -1
            anchors.verticalCenter: parent.verticalCenter
            x: track.sunCenter - width / 2
            source: root.sunSource
            width: 20
            height: 20
            color: root.dark ? Theme.textSecondary : Theme.textPrimary
        }

        ControlsImpl.IconImage {
            id: moonIcon
            z: -1
            anchors.verticalCenter: parent.verticalCenter
            x: track.moonCenter - width / 2
            source: root.moonSource
            width: 20
            height: 20
            color: root.dark ? Theme.textPrimary : Theme.textSecondary
        }

        TapHandler {
            id: toggleHandler
            acceptedButtons: Qt.LeftButton
            onTapped: Theme.toggle()
        }

        HoverHandler { id: hoverHandler }

        states: [
            State {
                when: hoverHandler.hovered
                PropertyChanges {
                    knob.border.color: root.dark ? Qt.lighter(Theme.toggleKnobActiveBorder, 1.25)
                                                  : Qt.darker(Theme.toggleKnobInactiveBorder, 1.2)
                }
            }
        ]
    }
}
