import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.15
import styles 1.0

ColumnLayout {
    id: root
    default property alias contentData: fieldContainer.data
    property alias label: labelItem.text
    property bool required: false
    property string helperText: ""
    property color labelColor: Theme.textPrimary
    property color helperColor: Theme.textSecondary

    spacing: root.helperText.length > 0 ? 4 : 2
    Layout.fillWidth: true

    RowLayout {
        spacing: 4
        Layout.fillWidth: true

        Label {
            id: labelItem
            text: "Label"
            color: root.labelColor
            font.pixelSize: 14
            Layout.fillWidth: true
        }

        Label {
            text: root.required ? "*" : ""
            color: Theme.accent
            font.pixelSize: 14
            visible: root.required
        }
    }

    ColumnLayout {
        id: fieldContainer
        Layout.fillWidth: true
    }

    Label {
        visible: root.helperText.length > 0
        text: root.helperText
        color: root.helperColor
        font.pixelSize: 12
        wrapMode: Label.Wrap
        Layout.fillWidth: true
    }
}
