import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.15
import styles 1.0

Frame {
    id: root
    property color backgroundColor: Theme.surface
    property color borderColor: Theme.surfaceBorder
    property int cornerRadius: 8
    property int contentPadding: 16

    Layout.fillWidth: true
    clip: true

    background: Rectangle {
        color: root.backgroundColor
        radius: root.cornerRadius
        border.color: root.borderColor
        border.width: 1
    }

    padding: root.contentPadding
}
