import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.15
import styles 1.0
import components.controls 1.0 as Controls

Item {
    id: root
    required property string title
    property bool showBackButton: false

    signal backClicked()

    Layout.fillWidth: true
    Layout.preferredHeight: 64
    implicitHeight: 64

    RowLayout {
        anchors.fill: parent
        anchors.leftMargin: root.showBackButton ? Theme.spacingMd : Theme.spacingLg
        anchors.rightMargin: Theme.spacingLg
        spacing: Theme.spacingSm

        Controls.IconButton {
            visible: root.showBackButton
            iconSource: Theme.iconUrl("chevron-left")
            Layout.preferredWidth: 36
            Layout.preferredHeight: 36
            onClicked: root.backClicked()
        }

        Label {
            Layout.fillWidth: true
            text: root.title
            color: Theme.textPrimary
            font.pixelSize: root.showBackButton ? 18 : 20
            font.weight: root.showBackButton ? Font.DemiBold : Font.Bold
            verticalAlignment: Text.AlignVCenter
            elide: Text.ElideRight
        }
    }

    Rectangle {
        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.right: parent.right
        height: 1
        color: Theme.surfaceBorder
    }
}
