import QtQuick 2.15
import QtQuick.Shapes 1.15
import styles 1.0

pragma ComponentBehavior: Bound

Item {
    id: root
    property string name: "play"
    property color color: Theme.textPrimary
    property real strokeWidth: 0
    implicitWidth: 28
    implicitHeight: 28

    Loader {
        id: iconLoader
        anchors.fill: parent
        sourceComponent: {
            switch (root.name) {
            case "pause":
                return pauseComponent
            case "stop":
                return stopComponent
            case "skip-back":
                return skipBackComponent
            case "skip-forward":
                return skipForwardComponent
            case "step-back":
                return stepBackComponent
            case "step-forward":
                return stepForwardComponent
            case "loop":
                return loopComponent
            default:
                return playComponent
            }
        }
    }

    Component {
        id: playComponent
        Shape {
            anchors.fill: parent
            antialiasing: true

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.32
                startY: root.height * 0.22

                PathLine { x: root.width * 0.32; y: root.height * 0.78 }
                PathLine { x: root.width * 0.72; y: root.height * 0.5 }
                PathLine { x: root.width * 0.32; y: root.height * 0.22 }
            }
        }
    }

    Component {
        id: pauseComponent
        Shape {
            anchors.fill: parent
            antialiasing: true

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.34
                startY: root.height * 0.24

                PathLine { x: root.width * 0.46; y: root.height * 0.24 }
                PathLine { x: root.width * 0.46; y: root.height * 0.76 }
                PathLine { x: root.width * 0.34; y: root.height * 0.76 }
                PathLine { x: root.width * 0.34; y: root.height * 0.24 }
            }

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.54
                startY: root.height * 0.24

                PathLine { x: root.width * 0.66; y: root.height * 0.24 }
                PathLine { x: root.width * 0.66; y: root.height * 0.76 }
                PathLine { x: root.width * 0.54; y: root.height * 0.76 }
                PathLine { x: root.width * 0.54; y: root.height * 0.24 }
            }
        }
    }

    Component {
        id: stopComponent
        Shape {
            anchors.fill: parent
            antialiasing: true

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.3
                startY: root.height * 0.3

                PathLine { x: root.width * 0.7; y: root.height * 0.3 }
                PathLine { x: root.width * 0.7; y: root.height * 0.7 }
                PathLine { x: root.width * 0.3; y: root.height * 0.7 }
                PathLine { x: root.width * 0.3; y: root.height * 0.3 }
            }
        }
    }

    Component {
        id: skipBackComponent
        Shape {
            anchors.fill: parent
            antialiasing: true

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.68
                startY: root.height * 0.22

                PathLine { x: root.width * 0.68; y: root.height * 0.78 }
                PathLine { x: root.width * 0.36; y: root.height * 0.5 }
                PathLine { x: root.width * 0.68; y: root.height * 0.22 }
            }

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.55
                startY: root.height * 0.22

                PathLine { x: root.width * 0.55; y: root.height * 0.78 }
                PathLine { x: root.width * 0.23; y: root.height * 0.5 }
                PathLine { x: root.width * 0.55; y: root.height * 0.22 }
            }

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.18
                startY: root.height * 0.22

                PathLine { x: root.width * 0.28; y: root.height * 0.22 }
                PathLine { x: root.width * 0.28; y: root.height * 0.78 }
                PathLine { x: root.width * 0.18; y: root.height * 0.78 }
                PathLine { x: root.width * 0.18; y: root.height * 0.22 }
            }
        }
    }

    Component {
        id: skipForwardComponent
        Shape {
            anchors.fill: parent
            antialiasing: true

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.32
                startY: root.height * 0.22

                PathLine { x: root.width * 0.64; y: root.height * 0.5 }
                PathLine { x: root.width * 0.32; y: root.height * 0.78 }
                PathLine { x: root.width * 0.32; y: root.height * 0.22 }
            }

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.45
                startY: root.height * 0.22

                PathLine { x: root.width * 0.77; y: root.height * 0.5 }
                PathLine { x: root.width * 0.45; y: root.height * 0.78 }
                PathLine { x: root.width * 0.45; y: root.height * 0.22 }
            }

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.82
                startY: root.height * 0.22

                PathLine { x: root.width * 0.72; y: root.height * 0.22 }
                PathLine { x: root.width * 0.72; y: root.height * 0.78 }
                PathLine { x: root.width * 0.82; y: root.height * 0.78 }
                PathLine { x: root.width * 0.82; y: root.height * 0.22 }
            }
        }
    }

    Component {
        id: stepBackComponent
        Shape {
            anchors.fill: parent
            antialiasing: true

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.65
                startY: root.height * 0.22

                PathLine { x: root.width * 0.65; y: root.height * 0.78 }
                PathLine { x: root.width * 0.32; y: root.height * 0.5 }
                PathLine { x: root.width * 0.65; y: root.height * 0.22 }
            }

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.22
                startY: root.height * 0.22

                PathLine { x: root.width * 0.32; y: root.height * 0.22 }
                PathLine { x: root.width * 0.32; y: root.height * 0.78 }
                PathLine { x: root.width * 0.22; y: root.height * 0.78 }
                PathLine { x: root.width * 0.22; y: root.height * 0.22 }
            }
        }
    }

    Component {
        id: stepForwardComponent
        Shape {
            anchors.fill: parent
            antialiasing: true

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.35
                startY: root.height * 0.22

                PathLine { x: root.width * 0.68; y: root.height * 0.5 }
                PathLine { x: root.width * 0.35; y: root.height * 0.78 }
                PathLine { x: root.width * 0.35; y: root.height * 0.22 }
            }

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.78
                startY: root.height * 0.22

                PathLine { x: root.width * 0.68; y: root.height * 0.22 }
                PathLine { x: root.width * 0.68; y: root.height * 0.78 }
                PathLine { x: root.width * 0.78; y: root.height * 0.78 }
                PathLine { x: root.width * 0.78; y: root.height * 0.22 }
            }
        }
    }

    Component {
        id: loopComponent
        Shape {
            anchors.fill: parent
            antialiasing: true

            ShapePath {
                strokeWidth: root.width * 0.12
                strokeColor: root.color
                fillColor: "transparent"
                capStyle: ShapePath.RoundCap
                joinStyle: ShapePath.RoundJoin
                startX: root.width * 0.5
                startY: root.height * 0.24

                PathArc {
                    x: root.width * 0.78
                    y: root.height * 0.5
                    radiusX: root.width * 0.3
                    radiusY: root.height * 0.3
                    direction: PathArc.Clockwise
                }

                PathArc {
                    x: root.width * 0.5
                    y: root.height * 0.78
                    radiusX: root.width * 0.3
                    radiusY: root.height * 0.3
                    direction: PathArc.Clockwise
                }

                PathArc {
                    x: root.width * 0.32
                    y: root.height * 0.56
                    radiusX: root.width * 0.26
                    radiusY: root.height * 0.26
                    direction: PathArc.Clockwise
                }
            }

            ShapePath {
                strokeWidth: root.strokeWidth
                strokeColor: root.color
                fillColor: root.color
                startX: root.width * 0.5
                startY: root.height * 0.24

                PathLine { x: root.width * 0.46; y: root.height * 0.3 }
                PathLine { x: root.width * 0.66; y: root.height * 0.24 }
                PathLine { x: root.width * 0.6; y: root.height * 0.44 }
                PathLine { x: root.width * 0.55; y: root.height * 0.34 }
                PathLine { x: root.width * 0.5; y: root.height * 0.24 }
            }
        }
    }
}
