import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.15
import features.player 1.0
import styles 1.0

Frame {
    id: root
    required property var appController
    required property var workspaceController
    property bool showFrameStrip: true

    Layout.fillWidth: true
    Layout.fillHeight: true
    Layout.preferredHeight: Theme.spacingXl * 22  // bias layout to give the player more vertical space
    topPadding: Theme.spacingSm
    leftPadding: Theme.spacingSm
    rightPadding: Theme.spacingSm
    bottomPadding: Theme.spacingSm

    background: Rectangle {
        radius: Theme.panelRadius
        color: Theme.surface
        border.color: Theme.surfaceBorder
    }

    contentItem: PlayerScreen {
        appWorkspaceController: root.appController
        workspaceController: root.workspaceController
        showFrameStrip: root.showFrameStrip
    }
}
