import QtQuick 2.15
import QtQuick.Layouts 1.15

import components.media 1.0
import components.workspace 1.0
import features.audiomix.panels 1.0
import styles 1.0

Item {
    id: root
    objectName: "AudioMixWorkspaceTab"
    width: 1280
    height: 720
    implicitWidth: 1280
    implicitHeight: 720

    required property var appController
    required property var timelineBackend
    required property var settingsModel

    readonly property var workspaceController: appController.cutWorkspaceController
    readonly property bool timelineReady: appController.mediaStatus === "ready"
    readonly property string timelineEmptyText: appController.mediaStatus === "loading"
                                                    ? qsTr("Building timeline...")
                                                    : appController.mediaStatus === "error"
                                                          ? appController.mediaError || qsTr("Timeline unavailable")
                                                          : qsTr("Open a media file to begin")
    readonly property real mediaDuration: appController.mediaDuration

    WorkspaceViewPreferences {
        id: viewPrefs
        settingsModel: root.settingsModel
        workspaceKey: "audiomix"
    }

    RowLayout {
        anchors.fill: parent
        spacing: Theme.spacingLg

        // Left Sidebar - Volume Controls
        AudioMixSidebar {
            id: sidebar
            Layout.preferredWidth: 320
            Layout.fillHeight: true
            timelineBackend: root.timelineBackend
            settingsModel: root.settingsModel
            exportFormController: root.appController.exportFormController
        }

        // Main Content Area
        ColumnLayout {
            Layout.fillWidth: true
            Layout.fillHeight: true
            spacing: Theme.spacingLg

            // Media Preview
            MediaPreviewCard {
                Layout.fillWidth: true
                Layout.fillHeight: true
                appController: root.appController
                workspaceController: root.workspaceController
                showFrameStrip: false
            }

            TimelineSection {
                Layout.fillWidth: true
                timelineBackend: root.timelineBackend
                appController: root.appController
                showOverviewTimeline: viewPrefs.prefs.showOverviewTimeline
                showAudioTimeline: viewPrefs.prefs.showAudioTimeline
                timelineReady: root.timelineReady
                emptyStateText: root.timelineEmptyText
            }
        }
    }
}
