import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.15
import styles 1.0
import "../../../components/controls" as Controls

RowLayout {
    id: root
    required property var workspaceController
    required property var timelineBackend
    required property var appWorkspaceController

    spacing: Theme.spacingSm
    Layout.fillWidth: true

    function hasSelectionRange() {
        return timelineBackend && timelineBackend.selectionRange && timelineBackend.selectionRange.length === 2
    }

    Controls.IconButton {
        objectName: "zoomOutButton"
        iconSource: Theme.iconUrl("zoom-out")
        enabled: root.timelineBackend
        onClicked: root.timelineBackend.zoomOut()
        ToolTip.text: qsTr("Zoom out")
        ToolTip.visible: hovered
        ToolTip.delay: 500
    }

    Controls.IconButton {
        objectName: "zoomInButton"
        iconSource: Theme.iconUrl("zoom-in")
        enabled: root.timelineBackend
        onClicked: root.timelineBackend.zoomIn()
        ToolTip.text: qsTr("Zoom in")
        ToolTip.visible: hovered
        ToolTip.delay: 500
    }

    Item { Layout.fillWidth: true }

    Button {
        objectName: "cutActionButton"
        text: qsTr("Cut Selection")
        enabled: root.hasSelectionRange() && root.workspaceController
        onClicked: root.workspaceController.cutSelection()
        ToolTip.text: qsTr("Remove the currently selected range from the export")
        ToolTip.visible: hovered
        ToolTip.delay: 500
    }

    Button {
        text: qsTr("Keep only selection")
        enabled: root.hasSelectionRange() && root.workspaceController
        onClicked: root.workspaceController.cutUnselected()
        ToolTip.text: qsTr("Cut everything outside the selection")
        ToolTip.visible: hovered
        ToolTip.delay: 500
    }

    Button {
        objectName: "uncutActionButton"
        text: qsTr("Uncut Selection")
        enabled: root.hasSelectionRange() && root.workspaceController
        onClicked: root.workspaceController.uncutSelection()
        ToolTip.text: qsTr("Restore cut portions within the selection")
        ToolTip.visible: hovered
        ToolTip.delay: 500
    }

    Button {
        text: qsTr("Clear All Cuts")
        enabled: root.workspaceController && root.workspaceController.cuts && root.workspaceController.cuts.length > 0
        onClicked: root.workspaceController.clearCuts()
    }

    Rectangle {
        Layout.preferredWidth: 1
        Layout.preferredHeight: 24
        color: Theme.surfaceBorder
    }

    Button {
        text: qsTr("Clear Selection")
        enabled: root.hasSelectionRange() && root.appWorkspaceController
        onClicked: root.appWorkspaceController.clearSelection()
    }

    Button {
        text: qsTr("Mark In")
        enabled: root.appWorkspaceController
        onClicked: root.appWorkspaceController.markIn()
        ToolTip.text: qsTr("Set selection start at playhead")
        ToolTip.visible: hovered
        ToolTip.delay: 500
    }

    Button {
        text: qsTr("Mark Out")
        enabled: root.appWorkspaceController
        onClicked: root.appWorkspaceController.markOut()
        ToolTip.text: qsTr("Set selection end at playhead")
        ToolTip.visible: hovered
        ToolTip.delay: 500
    }
}
