pragma ComponentBehavior: Bound

import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.15

import components.media 1.0
import components.workspace 1.0
import features.join.panels 1.0
import styles 1.0

Item {
    id: root
    objectName: "JoinWorkspaceTab"
    width: 1280
    height: 720
    implicitWidth: 1280
    implicitHeight: 720

    // Main app controller for file management and timeline
    required property var appWorkspaceController
    required property var settingsModel

    // Convenience aliases
    readonly property var joinModel: appWorkspaceController ? appWorkspaceController.joinModel : null
    readonly property bool hasFiles: joinModel ? joinModel.fileCount > 0 : false
    readonly property var timelineBackend: appWorkspaceController ? appWorkspaceController.timelineBackend : null

    WorkspaceViewPreferences {
        id: viewPrefs
        settingsModel: root.settingsModel
        workspaceKey: "join"
    }

    SplitView {
        anchors.fill: parent
        orientation: Qt.Horizontal

        handle: Rectangle {
            implicitWidth: Theme.spacingSm
            implicitHeight: parent.height
            color: "transparent"

            // Drag handle indicator
            Rectangle {
                anchors.centerIn: parent
                width: 3
                height: 40
                radius: 1.5
                color: Theme.surfaceBorder
                opacity: SplitHandle.hovered || SplitHandle.pressed ? 1.0 : 0.5

                Behavior on opacity { NumberAnimation { duration: 100 } }
            }
        }

        // Left Sidebar - File List
        JoinSidebar {
            id: sidebar
            SplitView.preferredWidth: 420
            SplitView.minimumWidth: 280
            SplitView.maximumWidth: 600
            appController: root.appWorkspaceController
        }

        // Main Content Area - Preview and Timeline
        ColumnLayout {
            SplitView.fillWidth: true
            SplitView.minimumWidth: 400
            spacing: Theme.spacingMd

            // Preview player
            MediaPreviewCard {
                Layout.fillWidth: true
                Layout.fillHeight: true
                Layout.preferredHeight: Theme.spacingXl * 22
                appController: root.appWorkspaceController
                workspaceController: root.appWorkspaceController
                showFrameStrip: false
                visible: root.hasFiles
            }

            // Empty state placeholder when no files
            Rectangle {
                Layout.fillWidth: true
                Layout.fillHeight: true
                color: Theme.background
                radius: Theme.panelRadius
                visible: !root.hasFiles

                Label {
                    anchors.centerIn: parent
                    text: qsTr("Add files to preview joined output")
                    color: Theme.textSecondary
                    opacity: 0.6
                }
            }

            // Overview timeline
            TimelineSection {
                id: timelineSection
                Layout.fillWidth: true
                timelineBackend: root.timelineBackend
                appController: root.appWorkspaceController
                showOverviewTimeline: true
                showAudioTimeline: viewPrefs.prefs.showAudioTimeline
                timelineReady: root.hasFiles
                emptyStateText: qsTr("Loading audio...")
            }
        }
    }
}
