import QtQuick 2.15
import QtQuick.Layouts 1.15
import styles 1.0

import ".." as PlayerPanels
import "." as PlayerViewComponents

ColumnLayout {
    id: root
    implicitWidth: 800
    implicitHeight: 450
    spacing: Theme.spacingLg

    required property var appWorkspaceController
    required property var workspaceController
    readonly property var appController: root.appWorkspaceController
    property bool showFrameStrip: true
    readonly property bool hasVideo: appWorkspaceController ? appWorkspaceController.hasVideo : false

    Item {
        Layout.fillWidth: true
        Layout.fillHeight: true
        visible: root.hasVideo

        ColumnLayout {
            anchors.fill: parent
            spacing: Theme.spacingSm

            PlayerViewComponents.PlayerView {
                Layout.fillWidth: true
                Layout.fillHeight: true
                appWorkspaceController: root.appWorkspaceController
            }

            PlayerPanels.FrameStrip {
                Layout.fillWidth: true
                visible: root.showFrameStrip
                appWorkspaceController: root.appWorkspaceController
            }
        }
    }

    RowLayout {
        Layout.fillWidth: true
        Layout.preferredHeight: 52
        Layout.maximumHeight: 52
        Layout.alignment: Qt.AlignHCenter
        spacing: Theme.spacingSm

        Item { Layout.fillWidth: true }

        PlayerPanels.PlaybackControls {
            Layout.alignment: Qt.AlignHCenter
            appWorkspaceController: root.appWorkspaceController
        }

        Item { Layout.fillWidth: true }
    }
}
